import { HttpClient } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { CommonModule } from '@angular/common';
import { MatTabsModule } from '@angular/material/tabs';

interface MenuItem {
  name: string;
  price: number;
  calories: number;
}

@Component({
  selector: 'app-main',
  standalone: true,
  imports: [CommonModule, MatTabsModule],
  templateUrl: './main.component.html',
  styleUrls: ['./main.component.css']
})
export class MainComponent implements OnInit {
  breakfast: MenuItem[] = [];
  lunch: MenuItem[] = [];
  dinner: MenuItem[] = [];

  constructor(private http: HttpClient) {}
  
  ngOnInit() {
    this.http.get<MenuItem[]>('assets/breakfast.json').subscribe({
      next: data => this.breakfast = data,
      error: err => console.error('Failed to load breakfast:', err)
    });
    
    this.http.get<MenuItem[]>('assets/lunch.json').subscribe({
      next: data => this.lunch = data,
      error: err => console.error('Failed to load lunch:', err)
    });
    
    this.http.get<MenuItem[]>('assets/dinner.json').subscribe({
      next: data => this.dinner = data,
      error: err => console.error('Failed to load dinner:', err)
    });
  }
}